<?php
/**
 * Database Configuration
 * Update these values to match your hosting environment
 */

// Database credentials
define('DB_HOST', 'localhost');           // Usually 'localhost' or your server IP
define('DB_NAME', 'capstone_school');     // Database name
define('DB_USER', 'root');                // Database username
define('DB_PASS', '');                    // Database password
define('DB_CHARSET', 'utf8mb4');

// Create database connection
function getDB() {
    static $pdo = null;
    
    if ($pdo === null) {
        try {
            $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
            $options = [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
            ];
            $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
        } catch (PDOException $e) {
            die(json_encode(['error' => 'Database connection failed: ' . $e->getMessage()]));
        }
    }
    
    return $pdo;
}

// Helper function to generate unique ID
function generateId($prefix = 's') {
    return $prefix . substr(md5(uniqid(mt_rand(), true)), 0, 10);
}

// Enable CORS (if frontend and backend are on different domains)
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Content-Type: application/json');

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}
?>
