# CAP-STONE HALL International School - Results Portal
## PHP + MySQL Version - Installation Guide

This version connects to your MySQL database and works across all devices.

---

## 📋 REQUIREMENTS

- **Web Server**: Apache or Nginx
- **PHP**: Version 7.4 or higher
- **MySQL**: Version 5.7 or higher (or MariaDB 10.2+)
- **PHP Extensions**: PDO, PDO_MySQL

Most hosting providers (cPanel, Plesk, shared hosting) already have these installed.

---

## 🚀 INSTALLATION STEPS

### Step 1: Upload Files

Upload these files to your web server:

```
your-website/
├── results/                    ← Create this folder
    ├── config.php             ← Database configuration
    ├── api.php                ← Main API endpoint
    ├── database.sql           ← Database schema
    └── index.html             ← Frontend (coming next)
```

### Step 2: Create Database

**Option A: Using phpMyAdmin (Easiest)**
1. Login to phpMyAdmin (usually at yourdomain.com/phpmyadmin)
2. Click "New" to create a database
3. Name it: `capstone_school`
4. Click "Import" tab
5. Choose file: `database.sql`
6. Click "Go"

**Option B: Using MySQL Command Line**
```bash
mysql -u your_username -p < database.sql
```

### Step 3: Configure Database Connection

Edit `config.php` and update these lines:

```php
define('DB_HOST', 'localhost');           // Your database host
define('DB_NAME', 'capstone_school');     // Your database name
define('DB_USER', 'your_db_username');    // Your database username
define('DB_PASS', 'your_db_password');    // Your database password
```

**Finding Your Database Credentials:**
- **cPanel**: Database section → MySQL Databases
- **Shared Hosting**: Check your hosting control panel
- **Contact Support**: If you can't find them, ask your hosting provider

### Step 4: Update Frontend

In `index.html`, find this line near the top of the `<script>` section:

```javascript
const API_URL = 'http://yourwebsite.com/results/api.php';
```

Change it to your actual website URL:

```javascript
const API_URL = 'https://www.capstonehallschool.com/results/api.php';
```

### Step 5: Test Installation

1. Visit: `https://yourwebsite.com/results/`
2. Try to login:
   - **Teacher**: username: `teacher`, password: `school123`
   - **Student**: Select 10th Grade → Christopher Oghenekome Divine → PIN: `1001`

---

## 🔐 DEFAULT CREDENTIALS

**Teacher/Admin Login:**
- Username: `teacher`
- Password: `school123`
- **⚠️ CHANGE THIS IMMEDIATELY** in Settings → Change My Password

**Sample Student:**
- Name: Christopher Oghenekome Divine
- Class: 10th Grade
- PIN: `1001`

---

## 🔧 TROUBLESHOOTING

### "Database connection failed"
- Check `config.php` credentials are correct
- Ensure MySQL service is running
- Verify database `capstone_school` exists

### "500 Internal Server Error"
- Check PHP error logs (usually in cPanel → Error Logs)
- Ensure PHP version is 7.4+
- Verify all files uploaded correctly

### "CORS Error" in browser console
- If frontend and backend are on different domains, uncomment CORS headers in `config.php`
- Or ensure both are on same domain

### "API endpoint not found"
- Check `API_URL` in index.html matches your actual URL
- Ensure `api.php` is accessible (try visiting it directly)

---

## 📁 FILE STRUCTURE EXPLAINED

| File | Purpose |
|------|---------|
| `config.php` | Database credentials & connection |
| `api.php` | Handles all database operations |
| `database.sql` | Database schema & sample data |
| `index.html` | Frontend interface |

---

## 🔄 UPDATING FROM LOCALSTORAGE VERSION

Your old data (from the offline version) is **NOT automatically transferred**. 

To transfer data:
1. In the old version, export students/scores manually
2. In the new version, use "Add Student" to re-enter
3. OR contact us for a migration script

---

## 🛡️ SECURITY RECOMMENDATIONS

1. **Change default password immediately**
2. **Use HTTPS** (SSL certificate) - most hosts provide free SSL
3. **Backup database regularly** (cPanel → Backup or use MySQL export)
4. **Keep PHP updated** to latest stable version
5. **Don't share database credentials**

---

## 📞 SUPPORT

If you need help:
1. Check error logs first
2. Verify all installation steps
3. Contact your hosting provider for server issues
4. Ensure PHP and MySQL versions meet requirements

---

## 🎓 HOW IT WORKS

**Data Flow:**
```
Browser (index.html) 
    ↓ JavaScript fetch()
API (api.php) 
    ↓ PHP PDO
Database (MySQL)
```

**All data is stored in MySQL**, not the browser. This means:
- ✅ Data persists across devices
- ✅ Multiple teachers can work simultaneously
- ✅ Students can check results from anywhere
- ✅ Data survives browser cache clearing

---

## 📝 CUSTOMIZATION

**To change school logo:**
- Edit `index.html`, find `BADGE_IMG` and `TEXTLOGO_IMG` variables
- Replace base64 strings with your own encoded images

**To add more classes:**
- Edit the `CLASSES` array in `index.html`
- Add default subjects in `database.sql`

**To modify subjects per class:**
- Login as teacher/admin
- Go to Subjects page
- Select class and add/remove subjects

---

## ✅ POST-INSTALLATION CHECKLIST

- [ ] Database created successfully
- [ ] `config.php` updated with correct credentials
- [ ] `index.html` updated with correct API_URL
- [ ] Can login as teacher
- [ ] Can login as student
- [ ] Can view Christopher's report card
- [ ] Changed default password
- [ ] Tested adding a new student
- [ ] Tested entering scores
- [ ] Print preview works correctly

---

**Installation Complete! 🎉**

Access your portal at: `https://yourwebsite.com/results/`
